if GetLocale() == "deDE" then
  local _, core = ...;
  local MonDKP = core.MonDKP;
  
  core.BossList = {
    MC = {
      "Lucifron", "Magmadar", "Gehennas",
      "Garr", "Baron Geddon", "Shazzrah", "Sulfuronherold", 
      "Golemagg der Verbrenner", "Majordomus Exekutus", "Ragnaros"
    },
    BWL = {
      "Feuerkralle der Ungezähmte", "Vaelastrasz der Verdorbene", "Brutwächter Dreschbringer",
      "Firemaw", "Ebonroc", "Flamegor", "Chromaggus", 
      "Nefarian"
    },
    AQ = {
      "Der Prophet Skeram", "Schlachtwache Sartura", "Fankriss der Unnachgiebige",
      "Prinzessin Huhuran", "Twin Emperors", "C'Thun", 
      "Adel der Silithiden", "Viscidus", "Ouro"
    },
    NAXX = {
      "Anub'Rekhan", "Großwitwe Faerlina", "Maexxna",
      "Noth der Seuchenfürst", "Heigan der Unreine", "Loatheb", 
      "Instrukteur Razuvious", "Gothik der Ernter", "Die vier Reiter",
      "Flickwerk", "Grobbulus", "Gluth", "Thaddius",
      "Saphiron", "Kel'Thuzad"
    },
    ZG = {
      "Bloodlord Mandokir", "Gahz'ranka", "Hakkar", "High Priest Thekal", "High Priest Venoxis", "High Priestess Arlokk",
      "High Priestess Jeklik", "Jin'do the Hexxer", "High Priestess Mar'li", "Edge of Madness"
    },
    AQ20 = {
      "Ayamiss der Jäger", "Buru der Verschlinger", "General Rajaxx", "Kurinnaxx", "Moam", "Ossirian der Narbenlose"
    },
    ONYXIA = {"Onyxia"},
    WORLD = {
      "Azuregos", "Lord Kazzak", "Smariss", "Lethon", "Ysondre", "Taerar"
    }
  }

  core.ZoneList = {
    "Geschmolzener Kern", "Pechschwingenhort", "Tempel von Ahn'Qiraj", "Naxxramas", "Zul'Gurub", "Ruinen von Ahn'Qiraj", "Onyxias Versteck", "Weltbosse"
  }

  core.L = {
    ADD                   = "Hinzufügen",
    ADDED                 = "Hinzugefügt",
    ADDGUILDCONFIRM       = "Bist du sicher, dass du alle Gildenmitglieder hinzufügen möchtest, die folgenden Rang haben:",
    ADDGUILDDKPTABLE      = "Gilde zur DKP-Tabelle hinzufügen",
    ADDGUILDDKPTABLETT    = "Fügt alle Gildenmitglieder des ausgewählten Ranges hinzu, die nicht bereits in der DKP-Tabelle enthalten sind.",
    ADDGUILDMEMBERS       = "Gildenmitglieder hinzufügen",
    ADDNEGTTDESC          = "Wenn diese Option aktiviert ist, wird die Verschuldung eines Spielers mit negativem DKP um den oben angegebenen Prozentsatz reduziert. Alle anderen werden um einen höheren Prozentsatz gekürzt. Nicht angekreuzte Spieler im Negativ sind vom Zerfall nicht betroffen.",
    ADDNEGTTWARN          = "Dieses Kontrollkästchen beeinflusst NUR das Verhalten des obigen Zerfalls bei negativen DKP-Spielern.",
    ADDNEGVALUES          = "Zu negativen Werten hinzufügen",
    ADDRAIDMEMBERS        = "Schlachtzugsmitglieder hinzufügen",
    ADDRAIDMEMBERSCONFIRM = "Bist du sicher, dass du fehlende Schlachtzugsmitglieder zur DKP-Tabelle hinzufügen möchtest?",
    ADDRAIDMEMBERSTTDESC  = "Füge alle Schlachtzug- und Gruppenmitglieder, die sich in der Gilde befinden, zur DKP-Tabelle hinzu.",
    ADDREMDKPTABLEENTRIES = "Hinzufügen/Entfernen von DKP-Tabelleneinträgen",
    ADDTARGET             = "Ziel hinzufügen",
    ADDTARGETTODKPTABLE   = "Ziel zur DKP-Tabelle hinzufügen",
    ADDTARGETTTDESC       = "Fügt das aktuelle Ziel, wenn es sich um einen Spieler handelt, der DKP-Tabelle hinzu. Dies erfordert, im Gegensatz zu allen anderen Optionen, nicht, dass das Ziel in der Gilde ist.",
    ADDTOMAXROLL          = "Zu Max Roll hinzufügen",
    ADDTOMAXROLLTTDESC    = "Fügt der maximalen Rolle einen vorbestimmten Wert hinzu.",
    ADDTOMAXROLLTTWARN    = "Beispiel: Wenn Sie möchten, dass Ihre Spieler maximal DKP + 500 mit einem oben festgelegten Bereich von 1 - MaxDKP würfeln, wird von einem Spieler mit 80 DKP / zufällig 1-580 erwartet.",
    ADDTOSTANDBY          = "Ausgewählte Spieler zur Standby-Liste hinzufügen",
    ADJUSTDESC            = "Wählen Sie einzelne Spieler von links aus (Umschalt + Klicken für mehrere Spieler) oder klicken Sie unten auf \"Alle sichtbaren auswählen\" und geben Sie den anzupassenden Betrag ein.\n\nDer Bereich kann mit \"Nur Schlachtzug anzeigen\" unten oder auf der Registerkarte \"Filter\" angepasst werden.",
    ADJUSTDKP             = "DKP einstellen",
    ADJUSTDKPTTDESC       = "Übernehmen Sie den obigen Eintrag für alle ausgewählten Spieler in der DKP-Tabelle.",
    ADJUSTDKPTTWARN       = "Dieser Eintrag wird an alle Online-Spieler in deiner Gilde gesendet.",
    ALL                   = "alle",
    ALLCLASSES            = "Alle Klassen",
    ALLOWNEGATIVEBIDDERS  = "Negative Bieter zulassen",
    ALLOWNEGATIVEBIDTTDESC= "Ermöglicht es einem Spieler zu bieten, wenn seine DKP derzeit negativ sind.",
    ALLTABLES             = "Alle Ihre Tabellen sind derzeit",
    ALREADYASSIGNED       = "Dieser Gegenstand ist diesem Spieler bereits zugewiesen.",
    AMONG                 = "unter",
    ANDCHARGEITTO         = "und lade es auf",
    APPDECAYTTDESC        = "Menge an DKP, um die Sie DKP-Einträge als wöchentlichen Zerfall reduzieren möchten. Dies sollte eine positive Zahl sein. Wenn \"Nur ausgewählte Spieler\" unten nicht ausgewählt ist, gilt dies für alle Einträge.",
    APPDECAYTTWARN        = "Warnung: Kann nicht rückgängig gemacht werden.",
    APPLYDECAY            = "Decay anwenden",
    AREYOUSURE            = "Sind Sie sicher, dass Sie geben möchten",
    AREYOUSUREBROADCAST   = "Möchten Sie die Einstellungen für den DKP-Modus wirklich übertragen?",
    AREYOUSUREREASSIGN    = "Möchten Sie die Zuordnung wirklich ändern?",
    ARTIFICIALINFLATION   = "Künstliche Inflation",
    ARTINFLATTTDESC       = "Punkte, die jedem Spieler OBEN auf die DKP gegeben werden, die unter ihnen aufgeteilt und verteilt wird. Dieser Wert wird zu ihrem verdienten DKP addiert, nachdem der Bankwert geteilt wurde.",
    AUTOAWARD             = "Auto Award DKP",
    AUTOAWARDTTDESC       = "Gewährt automatisch einen Boss-Kill-Bonus (DKP), wenn ein Boss getötet wird.",
    AWARDBONUS            = "Prämienbonus",
    AWARDBONUSTTDESC      = "Menge an DKP, die dem Raid jedes Mal gegeben werden soll, wenn das unten angegebene Intervall eingehalten wird.",
    AWARDINTERVAL         = "Auszeichnungsintervall",
    AWARDINTERVALTTDESC   = "Zeitintervall (in Minuten), in dem DKP für den gesamten Angriff vergeben werden soll.",
    AWARDINTERVALTTWARN   = "z.B. Wenn Sie 60 eingeben, wird der DKP-Betrag im Feld \"Bonus\" über jeder Stunde für den Schlachtzug (und, falls unten markiert, für den Standby-Modus) vergeben.",
    AWARDITEM             = "Auszeichnungsgegenstand",
    AWARDITEMTO           = "Auszeichnungsgegenstand an",
    BALANCE               = "Gleichgewicht",
    BCASTCOMPLETED        = "Alle Sendungen sind beendet.",
    BCASTDKPHIST          = "Ausstrahlung der DKP-Geschichte",
    BCASTDKPHISTBTN       = "Übertragung der DKP-Geschichte",
    BCASTDKPHISTCONF      = "Möchten Sie Ihre DKP-Verlaufstabelle wirklich übertragen?",
    BCASTDKPTABLEBTN      = "Übertragen Sie DKP-Tabelle",
    BCASTLOOTHIST         = "Broadcasting Loot History",
    BCASTLOOTHISTBTN      = "Broadcast-Loot-Geschichte",
    BCASTLOOTTABLECONF    = "Sind Sie sicher, dass Sie Ihre Beuteverlaufstabelle übertragen möchten?",
    BCASTMINBIDCONFIRM    = "Sind Sie sicher, dass Sie Ihre Mindestgebotseinstellungen an alle Beamten senden möchten?",
    BCASTVALUES           = "Broadcast-Werte",
    BCASTVALUESTTDESC     = "Broadcast über Mindestgebotswerten an alle Offiziere. Dadurch werden auch alle benutzerdefinierten Werte gesendet, die für bestimmte Elemente im Gebotsfenster festgelegt wurden.",
    BCASTVALUESTTWARN     = "Aktuelle Werte werden nicht überschrieben. Beim Empfang dieser Sendung werden bereits festgelegte Werte aktualisiert oder nicht vorhandene Werte hinzugefügt. Nicht gesendete Werte bleiben unverändert.",
    BELT                  = "Gürtel",
    BESTPRACTICES         = "|cffff0000OFFIZIERE BITTE LESEN|r: Dieses Update enthält keine neuen Funktionen oder Updates. Es ist ein vorbereitendes Update für Offiziere. 2.0 wird eine umfassende Überarbeitung des Systems beinhalten, wie es Aufzeichnungen führt und diese überträgt. Es ist von entscheidender Bedeutung, dass Migrationsanweisungen befolgt werden, um zu verhindern, dass doppelte Daten zu dramatisch falschen Datenbanken führen. Bei der nächsten Aktualisierung werden die Verantwortlichen aufgefordert, ihre aktuellen Tabellen zu migrieren. Dies kann nur von einem einzigen Offizier durchgeführt werden. Alle verbleibenden Offiziere werden aufgefordert, ihre Daten zu löschen, um die migrierten Daten des ausgewählten migrierenden Offiziers zu akzeptieren. Bitte koordinieren Sie dies in den nächsten Tagen, um Probleme zu vermeiden. Wenn die Daten einmal übertragen wurden, ist es schwierig, sie zu korrigieren, wenn sie falsch sind.\n\nWenn ein Offizier sich für eine Migration entscheidet, wird die öffentliche Notiz des Gildenleiters mit diesem Offiziersnamen aktualisiert, um allen anderen Offizieren anzuzeigen, dass die Datenbank bereits migriert wurde, und sie zu fragen, ob sie ihre aktuellen Daten löschen möchten (BITTE sichern Sie Ihre gespeicherten Variablen) Datei vor, nur für den Fall), und beauftragen Sie sie, eine Sendung von diesem Offizier zu erhalten, um den Prozess abzuschließen. Das Erzwingen einer Synchronisierung kann durch Klicken auf die Tabellenstatusanzeige unten links in der Haupt-GUI abgeschlossen werden. Nach dieser Migration sind alle Daten persistent. Für den Fall, dass die Migration auf irgendeine Weise blockiert wird, können alle Beamten, die Broadcasts erhalten haben, ihre gespeicherte Variablendatei löschen und gleichzeitig eine gesicherte Kopie erstellen. Dies muss gleichzeitig erfolgen, da ein Beamter, der die neuen indizierten Tabellen hat, diese sofort an Sie zurücksendet, wenn Sie sie löschen und sich anmelden. Sobald die Migration für alle Offiziere abgeschlossen ist, kann der GM-Hinweis, der den migrierenden Offizier angibt, gelöscht werden. Tun Sie dies NUR, wenn Sie sicher sind, dass alle Offiziere die neuen Tische haben.\n\nDarüber hinaus müssen alle Mitglieder auf 2.0 oder höher aktualisieren. Ältere Versionen sind nicht kompatibel.",
    BID                   = "Bieten, Gebot, Angebot",
    BIDACCEPTEDFILTER     = "Ihr Gebot wurde angenommen.",
    BIDCANCELLED          = "Ihr Gebot wurde storniert.",
    BIDDENIEDEXCEEDMAX    = "Gebot abgelehnt! Ihr Gebot hat den Höchstgebotswert von überschritten",
    BIDDENIEDFILTER       = "Gebot abgelehnt!",
    BIDDENIEDINVALID      = "Gebot abgelehnt! Ungültiges Gebot erhalten.",
    BIDDENIEDMINBID       = "Gebot abgelehnt! Unterhalb des Mindestgebots von",
    BIDDENIEDNEGATIVE     = "Gebot abgelehnt! Ihr DKP ist negativ",
    BIDDENIEDNOVALUE      = "Gebot abgelehnt! Kein Wert für das Gebot angegeben.",
    BIDDENIEDONLYHAVE     = "Gebot abgelehnt! Sie haben nur",
    BIDDINGCLOSED         = "Bieten geschlossen!",
    BIDHELP               = "Bieten Sie auf den aktuellen Artikel, wenn das Gebot geöffnet wird.",
    BIDMETHOD             = "Gebotsmethode",
    BIDTIMER              = "Bid Timer",
    BIDTIMERDEFAULTTTDESC = "Standardzeit für den Gebotstimer in Sekunden.",
    BIDTIMERTTDESC        = "Wie lange für diesen Artikel geboten wird, bleibt in Sekunden offen.",
    BIDTIMERTTWARN        = "Die Standardeinstellung kann auf der Registerkarte Optionen festgelegt werden.",
    BIDWASACCEPTED        = "Ihr Gebot wurde angenommen.",
    BIDWHISPARENOW        = "Gebotsflüstern sind jetzt",
    BLOCKOODBROADCAST     = "Sie können keine veralteten Tabellen senden. Dies würde zu einem nicht behebbaren Datenverlust führen. Wenn Sie sich absolut sicher sind, dass Sie über die aktuellsten Daten verfügen, können Sie dies beheben, indem Sie das Tag aus der öffentlichen Notiz des Gildenanführers löschen.",
    BONUS                 = "Bonus",
    BONUSAWARDED          = "Bonus verliehen",
    BOOTS                 = "Stiefel",
    BOSS                  = "Chef",
    BOSSKILLBONUS         = "Boss Kill Bonus",
    BOSSKILLBONUSTTDESC   = "Bonus für das Töten eines Chefs.",
    BRACERS               = "Armschienen",
    BROADCASTDKPTABLECONF = "Möchten Sie wirklich alle Tabellen übertragen? Dadurch wird Ihre Tabelle NICHT mit anderen zusammengeführt. Es wird die gesamten Gilden-Tabellen mit exakten Kopien von Ihnen vollständig überschreiben.",
    BROADCASTHEADER       = "Wenn die DKP-Verlaufs- oder Beuteverlaufstabellen größer als 100 Einträge sind, dauert es aufgrund der von Blizzard implementierten Maßnahmen zur Verhinderung von Überschwemmungen einige Zeit, bis sie gesendet werden. 2500 Einträge können bis zu 3-5 Minuten dauern. Bitte erlauben Sie 1-2 Sekunden zwischen den Sendungen, um gleichzeitige Aktualisierungen zu ermöglichen. \"Broadcast DKP Table\" sollte relativ augenblicklich sein. Alle Broadcasts sind GUILD-weit (mit Ausnahme von Bid / Raid-Timern, die auf RAID beschränkt sind).",
    BROADCASTSETTINGS     = "Broadcast-Einstellungen",
    BROADCASTSETTTDESC    = "Überträgt alle DKP-bezogenen Einstellungen, einschließlich der oben genannten DKP-Modusparameter, sowie Artikelwerte und Bonuswerte (in den Optionen festgelegt).",
    CANCEL                = "Stornieren",
    CASTERDPS             = "Caster DPS",
    CHEST                 = "Brust",
    CLASS                 = "Klasse",
    CLASSFILTER           = "Klassenfilter",
    CLEARBIDWINDOW        = "Sauberes Fenster",
    CLEARBIDWINDOWTTDESC  = "Löscht alle Artikelinformationen und abgegebenen Gebote aus dem Fenster.",
    CLEARSTANDBY          = "Standby-Liste löschen",
    CLICKQUERYGUILD       = "Klicken Sie hier, um die Gilde abzufragen, um herauszufinden, welche\nOffiziere, die online sind, Tabellen aktualisiert haben.",
    CLOAK                 = "Mantel",
    CLOSE                 = "Schließen",
    CLOSEDBIDINPROGRESS   = "Das Gebotsfenster wurde mit einem laufenden Gebot geschlossen! Geben Sie / dkp bid ein, um die aktuelle Gebotssitzung erneut zu öffnen.",
    COMMANDCHANNELS       = "Befehlskanäle",
    COMMANDCHANNELSTTDESC = "Wählen Sie die Kanäle aus, die Sie öffnen möchten, um! Bid- und! Dkp-Befehle zu erhalten. Sie können eine beliebige Kombination der drei zu öffnenden Optionen auswählen. Alle empfangenen Befehle, unabhängig vom Kanal, werden mit einem Flüstern beantwortet.",
    CONFAWARD             = "Auszeichnung bestätigen",
    CONFIRM               = "Bestätigen",
    CONFIRMADDTARGET      = "Sind Sie sicher, dass Sie hinzufügen möchten",
    CONFIRMAWARD          = "Sind Sie sicher, dass Sie vergeben möchten",
    CONFIRMDECAY          = "Bist du sicher, dass du verderben möchtest?",
    CONFIRMDELETEENTRY1   = "Möchten Sie den Eintrag wirklich löschen?",
    CONFIRMREMOVESELECT   = "Sind Sie sicher, dass Sie entfernen möchten",
    CONFIRMWHITELIST      = "Möchten Sie die ausgewählten Spieler wirklich zur Whitelist hinzufügen?",
    CONFIRMWHITELISTCLEAR = "Möchten Sie die Whitelist wirklich löschen?",
    CONGRATS              = "Glückwunsch",
    CONTACTOFFICER        = "Bitte wenden Sie sich an einen der oben als \"Auf dem Laufenden\" aufgeführten Mitarbeiter, um Ihre Tabellen aktualisieren zu lassen.",
    CONTINUERAID          = "Raid fortsetzen",
    CORRECTINGERROR       = "Fehler beheben",
    COSTAUTOUPDATE        = "Kosten Auto Update",
    COSTAUTOUPDATETTDESC  = "Wählen Sie aus, auf welche Kosten der Artikel während einer Gebotssitzung automatisch aktualisiert werden soll. \n\n|CFFFF0000Erster Bieter|r: Dadurch werden die Kosten des Artikels am unteren Rand des Gebotsfensters auf den Höchstbietenden aktualisiert. \n\n|CFFFF0000Zweiter Bieter|r: Hiermit werden die Kosten für den Artikel am unteren Rand des Gebotsfensters entweder auf den zweithöchsten Bieter oder, falls es nur einen Bieter gibt, auf den Mindestgebotswert aktualisiert. \n\nFür jeden Die Kosten können jederzeit im laufenden Betrieb bearbeitet werden.",
    COSTAUTOUPDATEVALUE   = "Kosten Auto-Update-Wert",
    CREATEDMAINTAIN       = "erstellt und gepflegt von",
    CREATERAIDTIMER       = "Erzeugt Raid Timer (nur Offiziere) (zB / dkp timer 120 Pizza Break!)",
    CURRENTLYHAS          = "hat derzeit",
    CURRENTLYSYNCING      = "Sie synchronisieren gerade Tabellen. Bitte warten Sie, bis der Vorgang abgeschlossen ist.",
    CURRNOTINGUILD        = "Du bist derzeit in keiner Gilde. Der DKP-Status kann nicht abgefragt werden.",
    CUSTOM                = "Brauch",
    CUSTOMMINBID          = "Benutzerdefiniertes Mindestgebot",
    CUSTOMMINBIDTTDESC    = "Sie haben ein benutzerdefiniertes Mindestgebot für diesen Artikel festgelegt. Deaktivieren Sie dieses Kontrollkästchen, um das Standardgebot für diesen Elementtyp zu verwenden (auf der Registerkarte Optionen festgelegt).",
    CUSTOMMINBIDTTWARN    = "Wenn Sie das Gebot mit dieser Option starten, wird der benutzerdefinierte Mindestgebotswert aus der Datenbank gelöscht.",
    DAY                   = "Tag",
    DAYS                  = "Tage",
    DECAYAMOUNT           = "Zerfallsbetrag",
    DECAYPERCENTAGE       = "Prozentsatz des Zerfalls",
    DECAYPERCENTAGETTDESC = "Prozentsatz zur Reduzierung aller DKP-Werte um für den routinemäßigen Zerfall.",
    DECAYPERCENTAGETTWARN = "NICHT eine negative Zahl.",
    DEFAULTDKPAWARDVALUES = "Standard DKP Award Werte",
    DEFAULTITEMCOSTS      = "Standardartikelkosten",
    DEFAULTMINBIDVALUES   = "Standard-Mindestgebotswerte",
    DEFAULTSETSAVED       = "Standardeinstellungen gespeichert.",
    DEFAULTSETTINGS       = "Standardeinstellungen",
    DELETEDKPENTRY        = "DKP-Eintrag löschen",
    DELETEENTRYREFUNDCONF = "Jegliche DKP, die von diesem Eintrag betroffen sind, werden von jedem aufgelisteten Spieler zurückerstattet / entfernt.",
    DISABLED              = "Deaktiviert",
    DISTRIBUTEALLDKPCONF  = "DKP an alle Spieler des Schlachtzugs verteilen?",
    DISTRIBUTEDKP         = "DKP verteilen",
    DISTRUBUTEBANKED      = "Verteilen Sie DKP mit Bankeinzug gleichmäßig an alle Schlachtzugsmitglieder, nachdem die Plünderungen für den aktuellen Boss abgeschlossen wurden.",
    DKP                   = "DKP",
    DKPADJUST             = "DKP einstellen",
    DKPADJUSTBY           = "DKP Bereinigt um",
    DKPAVAILABLE          = "DKP verfügbar",
    DKPAWARDHELP          = "Manuelles Auszeichnen von Gegenständen (nur für Offiziere) (z. B. / dkp award roeshambo 100 [Elementlink])",
    DKPBROADCASTED        = "DKP-Datenbank gesendet",
    DKPCMDHELP            = "Gibt deinen aktuellen DKP zurück (oder DKP von <Spielername>)",
    DKPDATAUPDATEDBY      = "DKP-Datenbank aktualisiert von",
    DKPENTRIESBY          = "DKP-Einträge von",
    DKPEXPORTHELP         = "Öffnet ein Fenster zum Exportieren aller DKP-Informationen in HTML, CSV oder XML. (Weitere Exportimplementierungen folgen)",
    DKPHISTCASTCOMP       = "DKP History Broadcast abgeschlossen",
    DKPHISTLIMITTTDESC    = "Maximal gespeicherte DKP-Verlaufseinträge.",
    DKPHISTLIMITTTWARN    = "Warnung: Wenn Sie die Anzahl der aktuell gespeicherten Einträge unterschreiten, wird der älteste gelöscht, um das Limit zu erreichen.",
    DKPHISTORY            = "DKP-Geschichte",
    DKPHISTORYLIMIT       = "DKP-Historienlimit",
    DKPHISTORYUPDATECOMP  = "DKP-Verlaufsaktualisierung abgeschlossen.",
    DKPHISTRECORDS        = "dkp history records",
    DKPHISTUPDATEPROG     = "DKP-Verlaufsaktualisierung wird durchgeführt",
    DKPLAUNCH             = "Startet DKP Window",
    DKPLOCKOUT            = "Zeigt das nächste Zurücksetzen für jede RAID-Größe an (Sperrung für 3 Tage, 5 Tage und 7 Tage).",
    DKPMINBID             = "DKP Mindestgebot",
    DKPMODES              = "DKP-Modi",
    DKPMODESENTCONF       = "DKP-Moduseinstellungen gesendet",
    DKPMODESFOOTER        = "Wenn in diesem Fenster Änderungen vorgenommen werden, muss Ihre Benutzeroberfläche |cffff0000MUSS|r neu geladen werden. Sie erhalten eine Fehlermeldung, wenn das Neuladen nicht abgeschlossen ist. Sie werden dazu aufgefordert, wenn das Fenster geschlossen wird.",
    DKPMODESHELP          = "Öffnet das DKP-Modi-Fenster (nur für Offiziere)",
    DKPMODESTTDESC        = "Wählen Sie den DKP-Modus aus, der im Gebotsfenster verwendet werden soll. Modusbeschreibungen werden oben bei der Auswahl angezeigt. Nach Auswahl des Modus neu laden.",
    DKPMODESTTDESC2       = "Konfigurieren Sie, welchen Typ von DKP-System Sie verwenden werden. Hohe Variabilität in jedem Modus.",
    DKPMODESTTWARN        = "Ihre Benutzeroberfläche MUSS neu geladen werden, wenn Einstellungen geändert werden. Sie werden beim Schließen dazu aufgefordert. Andernfalls werden Fehler verursacht.",
    DKPPRICE              = "DKP Preis",
    DKPRESETPOS           = "Setzt die Position / Größe des DKP-Fensters zurück",
    DKPROUNDING           = "DKP-Rundung",
    DKPROUNDINGTTDESC     = "Stellen Sie ein, wie viele Dezimalstellen Sie in Ihrem DKP-System verwenden möchten. Null würde runde ganze Zahlen bedeuten (keine Dezimalstellen)",
    DKPSTATUS             = "DKP-Status",
    DKPTOFOLLOWING        = "DKP an folgende Spieler",
    DKPWASACCEPTED        = "DKP wurde akzeptiert",
    DONTSHOW              = "Für diese Version nicht mehr anzeigen.",
    ELEMENTAL             = "Elementar",
    ENABLED               = "aktiviert",
    ENDBIDDING            = "Bieten beenden",
    ENDCURRAIDCONFIRM     = "Sind Sie sicher, dass Sie die aktuelle Razzia beenden möchten?",
    ENDRAID               = "Raid beenden",
    ENHANCEMENT           = "Verstärkung",
    ENTEROTHERREASONHERE  = "Geben Sie hier einen anderen Grund ein",
    ENTRIESSELECTED       = "Ausgewählte Einträge",
    ENTRIESSHOWN          = "Einträge angezeigt",
    ENTRYSELECTED         = "Eintrag ausgewählt",
    ERROR                 = "Error",
    ERRORPROCESSING       = "Fehler beim Verarbeiten des Befehls",
    EXPECTEDROLL          = "Erwartete Rolle",
    FERAL                 = "Wilder Kampf",
    FILTERS               = "Filter",
    FIRSTBIDDER           = "Erster Bieter",
    FIRSTKILL             = "Erste tötung",
    FOR                   = "zum",
    FORBACKSLOT           = "für Gegenstände im hinteren Steckplatz.",
    FORCHESTSLOT          = "für Gegenstände mit Brustschlitzen.",
    FORFEETSLOT           = "für Füße Slot Gegenstände.",
    FORFINGERSLOT         = "für Finger Slot Gegenstände.",
    FORHANDSLOT           = "für Gegenstände mit Handschlitzen.",
    FORHEADSLOT           = "für Gegenstände mit Kopfschlitzen.",
    FORLEGSLOT            = "für Beinplatzgegenstände.",
    FORNECKSLOT           = "für Nackenschlitzartikel.",
    FOROFFHANDSLOT        = "für Gegenstände aus der Hand (Schilde, Zaubernden aus der Hand).",
    FORONEHANDSLOT        = "für Einhandwaffen.",
    FOROTHERSLOT          = "für alle anderen Gegenstände, die nicht in die oben genannten Kategorien fallen (Köpfe, Herzen, Jägerblatt usw.)",
    FORPLAYERS            = "für die folgenden Spieler",
    FORRANGESLOT          = "für Gegenstände der Range Slots (Bögen, Waffen, Zauberstäbe, Relikte).",
    FORREASON             = "aus Gründen",
    FORSHOULDERSLOT       = "für Gegenstände mit Schulterschlitzen.",
    FORTRINKETSLOT        = "für Gegenstände für Schmuckstücke.",
    FORTWOHANDSLOT        = "für Zweihandwaffen.",
    FORWAISTSLOT          = "für Hüftschlitzartikel.",
    FORWRISTSLOT          = "für Gegenstände mit Handgelenkschlitzen.",
    FROMSTANDBYLIST       = "aus der Standby-Liste",
    GENDKPHIST            = "DKP-Verlauf erstellen",
    GENDKPTABLE           = "DKP-Tabelle generieren",
    GENLOOTHIST           = "Loot History generieren",
    GIVEENDBONUS          = "Gib den End Bonus",
    GIVEENDBONUSTTDESC    = "Durch Auswahl dieser Option erhält jeder im Schlachtzug (und im Standby-Modus, falls unten ausgewählt) den Bonus \"Raid Completion\", wenn Sie den Schlachtzug beenden.",
    GIVEONTIMEBONUS       = "Pünktlichkeitsbonus geben",
    GIVEONTIMETTDESC      = "Wenn Sie dies auswählen, erhalten alle Teilnehmer des Schlachtzugs (und im Standby-Modus, falls unten ausgewählt) den Bonus \"Pünktlich\", wenn Sie den Schlachtzug initialisieren.",
    GUILD                 = "Gilde",
    HANDS                 = "Hände",
    HEAD                  = "Kopf",
    HEALER                = "Heiler",
    HELPINFO              = "Zeigt Hilfeinformationen an",
    HIDDEN                = "versteckt",
    HIDEBIDTIMER          = "Gebotstimer ausblenden",
    HOLY                  = "Heilig",
    HOUR                  = "Stunde",
    HOURS                 = "Std",
    IN                    = "im",
    INCLUDESBYTTDESC      = "Bezieht Spieler in die Standby-Liste ein, wenn der oben aktivierte Boss Kill DKP automatisch vergeben wird.",
    INCLUDESBYTTWARN      = "Wenn Standby-Opt-In aktiv ist, wird DKP sofort für den Raid vergeben, während der Standby-Listen-Award bis zum Ablauf des zweiminütigen Opt-In-Fensters verschoben wird.",
    INCLUDESTANDBY        = "Standby einschließen",
    INCLUDESTANDBYLIST    = "Standby-Liste einschließen",
    INCLUDESTANDBYTTDESC  = "Durch Auswahl dieser Option wird die Standby-Liste in alle automatischen DKP-Verteilungen einbezogen.",
    INCLUDESTANDBYTTWARN  = "Erstellen Sie eine Standby-Liste, indem Sie Spieler auf dem DKP-Tisch auswählen, die sich nicht im Schlachtzug befinden. Klicken Sie dazu mit der rechten Maustaste auf> Standby-Liste verwalten> Ausgewählte Spieler zur Standby-Liste hinzufügen.",
    INCREMENTINVALIDWARN  = "Inkrement ist eine ungültige Zahl.",
    INCSTANDBYLISTTTDESC  = "Bezieht Spieler in die Standby-Liste in die Verteilung ein.",
    INCSTANDBYLISTTTWARN  = "Dies ergibt geringere Werte für die Spieler des Schlachtzugs.",
    INFLATION             = "Inflation",
    INITRAID              = "Raid initialisieren",
    INITRAIDTTDESC        = "Startet den Raid-Timer, um DKP basierend auf dem oben angegebenen Zeitinkrement zu vergeben. Dies kann von jedem Offizier in der Razzia initialisiert werden, aber nur der Razzia-Anführer gibt der DKP-Auszeichnung, dass die überprüften Bedingungen erfüllt sind.",
    INITRAIDTTWARN        = "Dies wird an alle Offiziere der Razzia übertragen. Jeder Offizier hat eine Zeitschaltuhr, aber NUR der Schlachtzugsführer vergibt die Auszeichnung. Wenn ein Ereignis eintritt (offline, neu laden usw.), bei dem der Anführer seinen Zeitgeber verliert, geben Sie den Anführer eines Schlachtzugs einem anderen Offizier, dessen Zeitgeber noch läuft, um eine Unterbrechung zu verhindern.",
    INPARTYRAID           = "In Party / Schlachtzug",
    INTEGER               = "Ganze Zahl",
    INTERVAL              = "Intervall",
    INVALIDBOSSNAME       = "Ungültiger Bossname",
    INVALIDITEMCOST       = "Artikel kann nicht vergeben werden. Ungültige Artikelkosten",
    INVALIDITEMLINK       = "Artikel kann nicht vergeben werden. Ungültiger Artikellink",
    INVALIDMINBIDENTRY    = "Ungültiger Mindestgebotseintrag um",
    INVALIDOPTIONENTRY    = "Ungültiger Optionseintrag um",
    INVALIDPLAYER         = "Ungültiger Spieler. Sie sind nicht in der DKP-Tabelle aufgeführt.",
    INVALIDROLLPARAM      = "Sie haben einen ungültigen Rollparameter festgelegt. Bitte überarbeiten Sie Ihre Einstellungen.",
    INVALIDROLLRANGE      = "Sie haben einen ungültigen Rollbereich eingestellt. Bitte überarbeiten Sie Ihre Einstellungen.",
    INVALIDTARGETPLAYER   = "Artikel kann nicht vergeben werden. Ungültiger Zielspieler",
    INVALIDTIMER          = "Ungültiger Timer",
    INVITE                = "Einladen",
    INVITESELECTED        = "Ausgewählte zum Raid einladen",
    ITEM                  = "Artikel",
    ITEMCOST              = "Gegenstandskosten",
    ITEMCOSTTTDESC        = "DKP, um dem Spieler den Gegenstand in Rechnung zu stellen.",
    ITEMCOSTTYPES         = "Artikelkostentypen",
    ITEMCOSTTYPESTTDESC   = "Wählen Sie die Art des Wertes, der für die Gegenstandskosten verwendet wird (was der Spieler für einen Gegenstand bezahlt). Ganzzahl oder Prozent. Diese Werte werden auf der Registerkarte \"Optionen\" festgelegt. \n\n|CFFFF0000Ganze Zahl|r: Die Elementkosten sind Ganzzahlen (Dezimalstellen werden auf die durch \"DKP-Rundung\" unten angegebene Dezimalstelle gerundet). Beispiel: 100 DKP. \n\n|CFFFF0000Prozent|r: Die Gegenstandskosten sind ein Prozentsatz der gesamten DKP des Gewinners. Beispiel: Der Spieler hat 1000 DKP, die Gegenstandskosten betragen 20%. Daher betragen die Gegenstandskosten für diesen Spieler 200 DKP.",
    LEGS                  = "Beine",
    LIFETIMEEARNED        = "Lebenszeit verdient",
    LIFETIMESPENT         = "Lebenszeit ausgegeben",
    LOAD                  = "Belastung",
    LOAD50MORE            = "Lade 50 weitere ...",
    LOADED                = "Geladen",
    LOOTBANKED            = "Loot Banked",
    LOOTHISTCASTCOMP      = "Loot History Broadcast abgeschlossen",
    LOOTHISTINST1         = "Umschalttaste + Klicken, um Element zu verknüpfen\nAlte + Klicken, um Zeile zu verknüpfen",
    LOOTHISTINST2         = "Klicken Sie mit der rechten Maustaste, um den Eintrag zu bearbeiten",
    LOOTHISTINST3         = "Klicken Sie mit der rechten Maustaste, um den Eintrag zu löschen",
    LOOTHISTLIMITTTDESC   = "Maximal gespeicherte Einträge in der Beute-Historie.",
    LOOTHISTLIMITTTWARN   = "Warnung: Wenn Sie die Anzahl der aktuell gespeicherten Einträge unterschreiten, wird der älteste gelöscht, um das Limit zu erreichen.",
    LOOTHISTORY           = "Beute-Geschichte",
    LOOTHISTORYLIMIT      = "Loot History Limit",
    LOOTHISTORYUPDATECOMP = "Loot History Update abgeschlossen.",
    LOOTHISTRECORDS       = "Beute Geschichtsaufzeichnungen und",
    LOOTHISTUPDATEPROG    = "Aktualisierung der Beute-Historie läuft",
    MAINGUISIZE           = "Haupt-GUI-Größe",
    MANAGE                = "Verwalten",
    MANAGECORELIST        = "Core Raider-Liste verwalten",
    MANAGEDKP             = "DKP-Einträge verwalten",
    MANAGELISTS           = "Listen verwalten",
    MANAGESTANDBY         = "Standby-Liste verwalten",
    MANUALLYDENIED        = "wurde verweigert.",
    MAX                   = "Max",
    MAXIMUMBID            = "Maximales Gebot",
    MAXIMUMBIDTTDESC      = "Dies ist ein festes Maximalgebot. Wenn ein Spieler versucht, ein höheres Gebot abzugeben, wird sein Gebot abgelehnt. Auf 0 setzen, wenn Sie keine max.",
    MAXIMUMROLL           = "Maximale Rolle",
    MAXIMUMROLLTTDESC     = "Stellen Sie die maximal zu verwendende Rolle ein. Lassen Sie das Feld leer, um die maximale DKP für den maximalen Wurf zu verwenden.",
    MAXIMUMROLLTTWARN     = "Lassen Sie das Feld für maximales DKP nur leer, wenn \"Prozentsatz verwenden\" deaktiviert ist. Wenn es aktiviert ist, verwenden Sie 100%.",
    MELEEDPS              = "Nahkampf-DPS",
    MIN                   = "Mindest",
    MINBIDDESCRIPTION     = "Bei Mindestgebotswerten wird allen Slots (oder einzelnen Artikeln) ein Mindestwert zugewiesen. Jeder, der ein Gebot abgibt, muss mit diesem oder einem höheren Wert bieten.\n\nEx: |cffa335ee|Hitem:16865::::::::120:577::::::|h[Breastplate of Might]|h|r fällt und hat einen Mindestgebotswert von 50 DKP. Jeder Spieler, der möchte, sendet \"! Bid 50\" (oder mehr) über einen der geöffneten Kanäle (unten ausgewählt), ohne die verfügbaren DKP zu überschreiten (es sei denn, DKP unter Null ist aktiviert). Der Spieler mit dem höchsten Gebot gewinnt und erhält entweder den Mindest-DKP-Wert oder den Wert, den der zweithöchste Bieter abgegeben hat. Lesen Sie die QuickInfos, um weitere Informationen zu erhalten.",
    MINBIDTTDESC          = "Mindestgebotswert, der akzeptiert wird.",
    MINBIDTTEXT           = "Wenn Sie einen anderen Wert als den unter Optionen festgelegten eingeben, wird dieser benutzerdefinierte Wert für das betreffende Element gespeichert.",
    MINBIDTTWARN          = "Die Standardeinstellungen können auf der Registerkarte Optionen festgelegt werden.",
    MINBIDVALUESHEAD      = "Mindestgebotswerte",
    MINBIDVALUESRECEIVED  = "Mindestgebot von erhalten",
    MINBIDVALUESSENT      = "Mindestgebot gesendet",
    MINIMUMBID            = "Mindestgebot",
    MINIMUMROLL           = "Minimum Roll",
    MINIMUMROLLTTDESC     = "Stellen Sie die zu verwendende Mindestrolle ein.",
    MINUTE                = "Minute",
    MINUTES               = "Protokoll",
    MONDKPSCALESIZE       = "Monolith DKP Scale Size",
    MONDKPSCALESIZETTDESC = "Maßstab des Monolith DKP-Fensters. Klicken Sie auf \"Save Settings\" (Einstellungen speichern), um die Größe auf den eingestellten Wert zu ändern.",
    MONDKPSCALESIZETTWARN = "Möglicherweise ist ein / reload nach dem Speichern erforderlich, wenn ein anderes Addon verwendet wird, das die Skalierung der Benutzeroberfläche ändert (z. B. TukUI, ElvUI usw.).",
    MORE                  = "Mehr",
    MOVEBIDTIMER          = "Bid Timer verschieben",
    MOVEME                = "Beweg mich!",
    MULTIPLESELECT        = "Mehrfachauswahl",
    NAMENOTFOUND          = "Ihr Name wurde nicht in der DKP-Datenbank gefunden.",
    NECK                  = "Hals",
    NEWBOSSKILLBONUS      = "Neuer Boss Kill Bonus",
    NEWBOSSKILLTTDESC     = "Bonus, der für das erste Mal gegeben wird, wenn ein Boss während eines Fortschrittsangriffs getötet wird.",
    NO                    = "Nein",
    NOBIDINPROGRESS       = "Keine Gebote in Bearbeitung",
    NOCORERAIDTEAM        = "Es gibt keine Spieler in Ihrem Kern-Schlachtzugsteam.",
    NOENTRIESSELECTED     = "Keine Einträge ausgewählt.",
    NOGUILD               = "Keine Gilde",
    NOITEMORITEMCOST      = "Keine Artikelkosten und / oder Artikel zum Bieten!",
    NOMINBIDORITEM        = "Kein Mindestgebot und / oder Gegenstand zum Bieten!",
    NONE                  = "Keiner",
    NOPARTYORRAID         = "Sie sind nicht in einer Partei oder in einem Überfall.",
    NOPERMISSION          = "Sie haben keine Berechtigung, auf diese Funktion zuzugreifen.",
    NOPLAYERINSTANDBY     = "Es befinden sich keine Spieler in der Standby-Gruppe.",
    NOPLAYERSSELECTED     = "Kein Spieler zum Übertragen von Beute ausgewählt.",
    NOPLAYERTARGETED      = "Kein Spieler als Ziel ausgewählt.",
    NOPOINTSTODISTRIBUTE  = "Es sind keine Punkte zu verteilen.",
    NORANKSELECTED        = "Es ist kein Rang ausgewählt.",
    NOROLEDETECTED        = "Keine Rolle erkannt",
    NOSPECREPORTED        = "Keine Spezifikation angegeben",
    NOTANOFFICER          = "ist kein Offizier. Du kannst nur Ränge hinzufügen, die in den Einstellungen der Gilde die Berechtigung \"Offiziersnotiz bearbeiten\" haben.",
    NOTETOOLONG           = "Die öffentliche Notiz der Gildenanführer war zu lang. Verkürzte Notiz passend zum DKP-Tabellen-Zeitstempel. (Maximal 31 Zeichen)",
    NOTIFICATIONSLIKETHIS = "Benachrichtigungen wie diese sind jetzt",
    NOTINGUILD            = "Nicht in der Gilde",
    NOTINRAID             = "Du bist nicht in einem Überfall.",
    NOTINRAIDFILTER       = "Nicht im Schlachtzug",
    NOTINRAIDPARTY        = "Du bist nicht in einer Schlachtzugsgruppe.",
    NOTSUBMITTEDBID       = "Sie haben kein Gebot abgegeben.",
    OFF                   = "aus",
    OFFHAND               = "Aus der Hand",
    OFFHANDITEMS          = "Gegenstände aus der Hand",
    OK                    = "okay",
    ON                    = "auf",
    ONEHANDED             = "Einhändig",
    ONEHANDEDWEAPONS      = "Einhandwaffen",
    ONETABLEOOD           = "Eine oder mehrere Ihrer Tabellen sind aktuell",
    ONLINE                = "Online",
    ONLYONEROLLWARN       = "Es kann nur eine Rolle angenommen werden!",
    ONLYPARTYRAID         = "Nur Party oder Schlachtzug",
    ONTIMEBONUS           = "Pünktlicher Bonus",
    ONTIMEBONUSTTDESC     = "Der Bonus gilt als rechtzeitig anwesend für einen Überfall.",
    OODDKPHISTORYDELETE   = "hat versucht, ein Element aus einer veralteten DKP-Verlaufstabelle zu löschen. Dies kann zu irreversiblen Schäden an Ihrer DKP-Tabelle führen. Möchten Sie annehmen?",
    OODDKPHISTORYENTRY    = "hat einen Eintrag von veraltetem DKP History Table gesendet. Dies kann zu irreversiblen Schäden an Ihrer DKP-Verlaufstabelle führen. Möchten Sie annehmen?",
    OODDKPHISTORYTABLE    = "hat eine veraltete DKP-Verlaufstabelle gesendet. Dies kann zu irreversiblen Schäden an Ihrer DKP-Verlaufstabelle führen. Möchten Sie annehmen?",
    OODDKPTABLEBROADCAST  = "hat eine veraltete DKP-Tabelle gesendet. Dies kann zu irreversiblen Schäden an Ihrer DKP-Tabelle führen. Möchten Sie annehmen?",
    OODLOGSYNC            = "hat eine veraltete Beuteverlaufstabelle gesendet. Dies kann irreversiblen Schaden an deiner Beuteverlaufstabelle verursachen. Möchten Sie annehmen?",
    OODLOOTHISTORYDELETE  = "hat einen Gegenstand aus einer veralteten Beuteverlaufstabelle gelöscht. Dies könnte dazu führen, dass das falsche Element in Ihrer Tabelle gelöscht wird. Möchten Sie annehmen?",
    OODLOOTTABLEITEM      = "hat versucht, einen Gegenstand aus einer veralteten Beutetabelle zu aktualisieren. Dies kann zu irreversiblen Schäden an Ihrer DKP-Tabelle führen. Möchten Sie annehmen?",
    OPENBIDWINDOWHELP     = "Öffnet das Gebotsfenster (nur für Offiziere) (z. B. / dkp-Gebot [Elementlink])",
    OPENCHANNELS          = "Kanäle öffnen",
    OPTIONS               = "Optionen",
    OR                    = "oder",
    ORABOVE               = "oder höher?",
    OTHER                 = "Andere",
    OTHERREASONVALIDATE   = "Kein anderer Grund ausgewählt",
    OUTDATEMODIFYWARN     = "Sie versuchen, eine veraltete DKP-Tabelle zu ändern. Dies könnte versehentlich Daten für die Offiziere beschädigen, die über die neuesten Tabellen verfügen.\n\nSind Sie sicher, dass Sie dies tun möchten?",
    OUTOFDATE             = "veraltet",
    OUTOFDATEANNOUNCE     = "Ihre Version von Monolith DKP ist veraltet. Bitte aktualisieren Sie Curse / Twitch oder WoWInterface, um sicherzustellen, dass keine Kompatibilitätsprobleme vorliegen.",
    PAUSERAID             = "Raid anhalten",
    PAUSERAIDTTDESC       = "Dies unterbricht einen Raid-Timer, wenn der Anführer entscheidet, dass der Timer für Pausen angehalten werden soll.",
    PAUSERAIDTTWARN       = "Kann durch Klicken auf \"Raid fortsetzen\" fortgesetzt werden.",
    PERCENT               = "Prozent",
    PERCENTCOST           = "Prozentuale Kosten",
    PLAYER                = "Spieler",
    PLAYERCOST            = "Spielerkosten [Item Link]",
    PLAYERNAME            = "Spielername",
    PLAYERNOTFOUND        = "Dieser Spieler wurde nicht gefunden.",
    PLAYERREASONVALIDATE  = "Kein Spieler oder Grund ausgewählt",
    PLAYERRECORDS         = "Spieleraufzeichnungen",
    PLAYERROLL            = "Spieler würfeln",
    PLAYERS               = "Spieler",
    PLAYERSFORREASON      = "Spieler aus gutem Grund",
    PLAYERVALIDATE        = "Kein Spieler ausgewählt",
    PLEASEUSENUMS         = "Bitte verwenden Sie Zahlen.",
    POINTS                = "Punkte",
    POINTSTTDESC          = "Geben Sie den DKP-Betrag ein, der an ausgewählte Spieler am DKP-Tisch verteilt werden soll. Die Standardwerte können auf der Registerkarte \"Optionen\" unten geändert werden.",
    POINTSTTWARN          = "Verwenden Sie eine negative Zahl, um DKP von ausgewählten Spielern zu entfernen.",
    POPOUTTIMER           = "Pop Out Raid Timer",
    POPOUTTIMERDESC       = "Öffnet den Schlachtzugs-Timer in einem separaten kompakten Fenster.",
    POSITIONRESET         = "Fensterposition zurücksetzen",
    PROTECTION            = "Schutz",
    PURGECONFIRM          = "Möchten Sie die DKP-Liste wirklich löschen?",
    PURGELIST             = "DKP-Liste löschen",
    PURGELISTTTDESC       = "Löscht die DKP-Liste aller Spieler, die keine DKP und keine DKP-Historie haben.",
    RAID                  = "Überfall",
    RAIDCOMPLETEBONUSTT   = "Bonus für jeden, der an einem Raid teilnimmt.",
    RAIDCOMPLETIONBONUS   = "Raid-Abschlussbonus",
    RAIDDKPADJUSTBY       = "Raid DKP Bereinigt um",
    RAIDENDED             = "Schlachtzug beendet",
    RAIDPAUSE             = "Schlachtzug wurde unterbrochen bei",
    RAIDPAUSED            = "Schlachtzug pausiert",
    RAIDRESUME            = "Schlachtzug wurde fortgesetzt!",
    RAIDSTART             = "Schlachtzugszeit ist abgelaufen!",
    RAIDTIMER             = "Schlachtzugstimer",
    RAIDTIMERBONUSCONFIRM = "Sind Sie sicher, dass Sie den Pünktlichkeitsbonus auf diesen Überfall anwenden möchten?",
    RAIDTIMERCONCLUDE     = "Schlachtzugstimer wurde nach beendet",
    RANGE                 = "Reichweite",
    RANGEDPS              = "Bereich DPS",
    RANK                  = "Rang",
    RANKLIST              = "Rangliste",
    RANKLISTTTDESC        = "Wählen Sie einen Rang aus und klicken Sie auf \"Gildenmitglieder hinzufügen\", um alle Gildenmitglieder des ausgewählten Rangs zur DKP-Tabelle hinzuzufügen.",
    REASON                = "Grund",
    REASONFORADJUSTMENT   = "Grund für die Anpassung",
    REASONTTDESC          = "Wählen Sie den Grund für die DKP-Anpassung. Wenn \"Boss Kill Bonus\" oder \"New Boss Kill Bonus\" ausgewählt ist, wird ein zusätzliches Dropdown-Menü zur Auswahl der Zone und des Bosses erstellt. \"Andere\" erstellt ein Textfeld, in das Sie einen benutzerdefinierten Grund eingeben können.",
    REASONTTWARN          = "Wenn ein Boss getötet wird, werden die entsprechende Zone und der Boss automatisch für Sie ausgewählt.",
    REASSIGNSELECTED      = "Neuzuweisung zum ausgewählten Spieler",
    RECENTHISTORYFOR      = "Jüngste Geschichte für",
    RELOADUICONFIRM       = "Damit diese Einstellungen wirksam werden, müssen wir Ihre Benutzeroberfläche neu laden. Möchten Sie dies jetzt tun?",
    RELOADUIFORSETTINGS   = "hat die DKP-Definitionen aktualisiert. Möchten Sie Ihre Benutzeroberfläche neu laden, um diese Änderungen widerzuspiegeln?",
    REMOVE                = "Entfernen",
    REMOVEENTRIES         = "Einträge entfernen",
    REMOVEENTRY           = "Eintrag entfernen",
    REMOVEFROMSTANDBY     = "Ausgewählte Spieler aus der Standby-Liste entfernen",
    REMOVESELECTEDENTRIES = "Ausgewählte Einträge entfernen",
    REMSELENTRIESTTDESC   = "Entfernt ausgewählte Spieler vom DKP-Tisch. Alle Referenzen dieses Spielers bleiben erhalten (DKP-Historie und Loot-Historie), ihr Name wird jedoch grau angezeigt.",
    REMSELENTRIESTTWARN   = "Warnung: Diese Aktion ist permanent.",
    REQUESTTABLESOFFICER  = "Fordern Sie aktualisierte Tabellen von einem Offizier an.",
    RESETPREVCONFIRM      = "Möchten Sie das vorherige DKP wirklich zurücksetzen?",
    RESETPREVDKP          = "Vorheriges DKP zurücksetzen",
    RESETPREVDKPTTDESC    = "Setzt den vorherigen DKP-Zähler auf den aktuellen DKP zurück (kleine graue +/- Zahlen neben dem aktuellen DKP jedes Spielers). Dies hat keinerlei Auswirkungen auf die Funktionalität. Nur ein Hinweis darauf, wie viel jeder Spieler seit dem letzten Zurücksetzen verdient / ausgegeben hat.",
    RESETPREVDKPTTWARN    = "Empfohlen, in regelmäßigen Abständen (wöchentlich, monatlich usw.) zurückzusetzen. Dies ist eine QOL-Funktion, die sich nicht auf die Funktionalität auswirkt.",
    RESETPREVIOUS         = "Vorherige zurücksetzen",
    RESETSIN              = "setzt in zurück",
    RESTORATION           = "Wiederherstellung",
    RETRIBUTION           = "Vergeltung",
    RINGS                 = "Ringe",
    ROLE                  = "Rolle",
    ROLLBIDDINGHEAD       = "Roll Based Bidding",
    ROLLDESCRIPTION       = "Bei rollbasierten Geboten haben Sie mehrere Optionen für Parameter. Sie können unten die Art der Rollen auswählen, die Sie verwenden möchten. Die von Ihnen festgelegten Optionen sind keine Parameter dafür, ob ein Wurf akzeptiert oder abgelehnt wird. Es werden jedoch die erwarteten Rollwerte im Gebotsfenster zur Überprüfung angezeigt. Sie können mit der rechten Maustaste auf ihre Rolle klicken und sie entfernen, wenn sie nicht den richtigen Parametern entspricht.",
    ROLLFOR               = "Rollen für",
    ROLLNOTACCEPTED       = "Ihre Rolle wurde nicht akzeptiert. Sie haben nur",
    ROLLRANGE             = "Rollenbereich",
    ROLLSETTINGS          = "Rolleneinstellungen",
    SAVESETTINGS          = "Einstellungen speichern",
    SEARCH                = "Suche   ",
    SEARCHDESC            = "Filtert die DKP-Liste. Sucht nach Name, Klasse, Spezifikation, Rang und Rolle.",
    SECONDBIDDER          = "Zweiter Bieter",
    SECONDS               = "Sekunden",
    SELECTALL             = "Wählen Sie Alle",
    SELECTALLVISIBLE      = "Wählen Sie Alle sichtbar",
    SELECTBOSS            = "Wählen Sie Chef",
    SELECTED              = "ausgewählt",
    SELECTRANK            = "Wählen Sie Rang",
    SELECTREASON          = "Grund auswählen",
    SELPLAYERSONLY        = "Nur ausgewählte Spieler",
    SELPLAYERSTTDESC      = "Wendet den obigen DKP-Zerfall auf |cffff0000NUR |r ausgewählte Spieler in der DKP-Tabelle an",
    SELPLAYERSTTWARN      = "Nützlich, um einen Zerfall auf Spieler anzuwenden, die eine bestimmte Schwelle überschreiten.",
    SENDWHITELIST         = "Whitelist senden",
    SENDWHITELISTTTDESC   = "Überträgt Ihre Whitelist an alle leitenden Angestellten.",
    SENDWHITELISTTTWARN   = "Es wird empfohlen, dies zu tun, wenn alle Offiziere online sind. Wenn ein Offizier diese Whitelist nicht erhält, hat er die vollen Offiziersrechte. Sie können ihre Informationen jedoch nicht an andere Beamte weitergeben. Sie werden benachrichtigt, wenn sie es versuchen. Wenn Sie diese Benachrichtigung erhalten, senden Sie die Whitelist und ihre Berechtigungen werden entfernt.",
    SETWHITELIST          = "Whitelist setzen",
    SETWHITELISTTTDESC1   = "Fügt ausgewählte Offiziere aus der DKP-Tabelle zur Whitelist hinzu. Whitelist wird verwendet, um | cffff0000limit | r die Offiziere zu erstellen, die Berechtigungen zum Ändern von DKP-Werten haben.",
    SETWHITELISTTTDESC2   = "Wenn Sie diese Option ohne ausgewählte Spieler verwenden, wird Ihre Whitelist gelöscht.",
    SETWHITELISTTTWARN    = "Nur Offiziere können in die Whitelist aufgenommen werden. Diese Option wird ausschließlich verwendet, um einzuschränken, welche Offiziere über Offiziersrechte in diesem Addon verfügen. Wenn Sie möchten, dass alle Beamten die Erlaubnis haben, lassen Sie die Whitelist leer.",
    SHADOW                = "Schatten",
    SHOULDERS             = "Schultern",
    SLASHCOMMANDLIST      = "Liste der Slash-Befehle",
    SPEC                  = "Spezialisierung",
    STANDBYOPTIN          = "Standby-Anmeldung",
    STANDBYOPTINBEGIN     = " wurde getötet. Bitte poste! Standby (oder! Standby Mains_Name, wenn in einer Alternative die Schreibweise genau sein muss.) In den Gilden-Chat, um DKP zu erhalten. Die Opt-in-Frist läuft in 120 Sekunden ab.",
    STANDBYOPTINEND       = "Das Standby-Opt-in ist abgelaufen für:",
    STANDBYOPTINTTDESC    = "Melden Sie sich bei der Gilde an, nachdem ein Boss getötet wurde, und fordern Sie die im Standby-Modus befindlichen Personen auf, sich anzumelden, indem Sie! Standby oder! Standby NAME (falls vorhanden) in den GILD-Chat eingeben. Die Anmeldesitzung bleibt zwei Minuten lang geöffnet. Die Standby-Liste wird nach jedem Boss-Kill gelöscht, bevor der Kill angekündigt wird.",
    STANDBYOPTINTTWARN    = "Wenn die automatische DKP-Verteilung bei Boss-Kill aktiv ist, erfolgt die automatische Verteilung für die Standby-Liste, wenn der zweiminütige Opt-In-Timer abläuft.",
    STARTBIDDING          = "Beginnen Sie mit dem Bieten",
    STARTBIDDINGTTDESC    = "Startet das Bieten für den aktuellen Artikel. Gebote werden nur angenommen, solange dies läuft.",
    STARTBIDDINGTTWARN    = "Die Bietdauer kann im Feld \"Bid Timer\" eingestellt werden. Durch das Starten einer zweiten Gebotssitzung für einen Artikel werden vorherige Gebote nicht gelöscht (zur Verwendung, wenn jemand in der letzten Sekunde ein Gebot abschneidet).",
    STATIC                = "Statisch",
    STATICDESCRIPTION     = "Mit Static Item Values ​​wird allen Slots (oder einzelnen Items) ein statischer Wert zugewiesen. Ein Gebot wird von jedem Spieler (mit! Gebot) abgegeben, der den Gegenstand haben möchte, und der Spieler mit dem höchsten verfügbaren DKP gewinnt. Die Kostenoptionen sind \"Ganzzahl\" oder \"Prozent\".\n\nEx: |cffa335ee|Hitem:19143::::::::120:577::::::|h[Flameguard Gauntlets]|h|r fällt ab und hat einen statischen Wert von 50 DKP. Jeder Spieler, der möchte, verwendet \"! Bid\" über einen der geöffneten Kanäle (unten ausgewählt). Der Spieler mit dem höchsten verfügbaren DKP gewinnt und erhält diesen statischen Wert. Lesen Sie die QuickInfos, um weitere Informationen zu erhalten.",
    STATICITEMVALUESHEAD  = "Statische Artikelwerte",
    SUBMITBUGS            = "für Hilfe und senden Sie alle Fehler",
    SUBZEROBIDDING        = "Sub Zero Bidding",
    SUBZEROBIDDINGTTDESC  = "Ermöglicht Spielern das Bieten, wenn sie nicht über genügend DKP verfügen oder ein höheres Gebot als das verfügbare DKP (abhängig von den Einstellungen des Modus) abgeben Maximales Gebot (siehe unten), damit sie ins Negativ gehen können. \n\n|cffff0000Andere|r: Ermöglicht es dem Spieler, ein Gebot abzugeben, selbst wenn ihre verfügbaren DKP durch die Kosten des Gegenstands überschritten werden.",
    SUPPRESSBIDWHISP      = "Bid Whispers unterdrücken",
    SUPPRESSNOTIFICATIONS = "Unterdrücken Sie die Addon-Benachrichtigungen",
    SUPPRESSNOTIFYTTDESC  = "Verbirgt alle Zusatznachrichten vor der Anzeige in Ihrem Chat-Frame.",
    SUPPRESSNOTIFYTTWARN  = "Broadcast-Updates werden weiterhin empfangen.",
    SUPRESSBIDWHISPTTDESC = "Unterdrückt eingehendes und ausgehendes Flüstern im Zusammenhang mit Geboten, während ein Gebot ausgeführt wird.",
    SUPRESSBIDWHISPTTWARN = "Alle anderen Flüstern, die nicht mit dem Bieten zusammenhängen, werden weiterhin angezeigt.",
    TABLEQUERYHEADER      = "DKP-Tabellenstatus der Gilde",
    TABLEQUERYNONOFFICER  = "Nichtoffizier-Tabellenstatus (Online)",
    TABLEQUERYOFFICER     = "Offiziertabellenstatus (Online)",
    TABLEQUERYOOD         = "Veraltet",
    TABLEQUERYSENT        = "DKP-Tabellenstatus der Gilde abfragen",
    TABLEQUERYUTD         = "Auf dem Laufenden",
    TABLEVIEWS            = "Tabellenansichten",
    TAKINGBIDSON          = "Gebote annehmen",
    TANK                  = "Panzer",
    TENSECONDSTOBID       = "Noch 10 Sekunden zum Bieten!",
    THISWILLREFUND        = "Dies wird erstattet",
    TIMEELAPSED           = "Verstrichene Zeit",
    TIMEINTERVALBONUS     = "Zeitintervall-Bonus",
    TIMERSIZE             = "Timer-Größe",
    TIMERSIZETTDESC       = "Skala des Gebots- / Schlachtzugszeitgebers.",
    TIMERSIZETTWARN       = "Die Position kann angepasst werden, indem Sie auf \"Move Bid Timer\" klicken und an die gewünschte Position ziehen.",
    TIMERWARNING          = "Warnung: Bitte stellen Sie sicher, dass Ihre DKP-Bonusparameter richtig eingestellt sind. Diese können in den obigen Feldern \"Intervall\" und \"Bonus\" sowie in allen \"Standard-DKP-Prämienwerten\" auf der Registerkarte \"Optionen\" festgelegt werden. Es wird empfohlen, diese Werte festzulegen und sie über das Fenster DKP-Modi (zugänglich über \"/dkp Modi\" oder die Schaltfläche auf der Registerkarte \"Optionen\") an alle Beamten zu senden, bevor Sie sie verwenden.",
    TO                    = "zu",
    TOBID                 = "bieten",
    TOBIDROLLRANGE        = "Gebot abgeben / zufällig. Ihre erwartete Reichweite können Sie der DKP-Tabelle oder mithilfe von entnehmen",
    TOBIDUSE              = "Gebot abgeben",
    TODKPLIST             = "zur DKP-Liste?",
    TOOMANYPLAYERSSELECT  = "Zu viele Spieler ausgewählt.",
    TORAID                = "überfallen",
    TOSEND                = "senden",
    TOSTANDBYLIST         = "zur Standby-Liste",
    TOTALDKP              = "DKP insgesamt",
    TOTALDKPAWARD         = "DKP insgesamt vergeben",
    TOTALMONDKPUSERS      = "Gesamtzahl der MonDKP-Benutzer",
    TOWITHDRAWBID         = "Ihr Gebot zurückziehen.",
    TRINKET               = "Schmuckstück",
    TTHISTORYCOUNT        = "Tooltip-Verlaufsanzahl",
    TTHISTORYCOUNTTTDESC  = "Anzahl der Einträge in der Beute- / DKP-Historie, die im Tooltip aufgeführt sind.",
    TWOHANDED             = "Beidhändig",
    TWOHANDEDWEAPONS      = "Zweihandwaffen",
    UNAUTHUPDATE1         = "hat versucht, geänderte Tabellen zu senden. Er ist kein Teil Ihrer Offiziere auf der Whitelist.",
    UNAUTHUPDATE2         = "hat versucht, geänderte Tabellen zu senden. Er ist kein bestimmter Offizier in Ihrer Gilde.",
    UNEXCUSEDABSENCE      = "Unentschuldigte Abwesenheit",
    UNEXCUSEDTTDESC       = "Strafe für unentschuldigte Abwesenheit vom Überfall.",
    UNEXCUSEDTTWARN       = "Sollte eine negative Zahl sein.",
    UPTODATE              = "auf dem Laufenden",
    USE                   = "Verwenden",
    USEPERCENTAGE         = "Prozent verwenden",
    USEPERCFORROLLS       = "Verwenden Sie Prozentsatz für Rollen",
    USEPERCROLLSTTDESC    = "Konvertiert die über dem Wurf liegenden Bereiche in% der DKP des Spielers. IE: Ein Spieler mit 1000 dkp, bei dem oben 70% - 100% eingestellt sind, wird voraussichtlich \n/zufällig 700-1000 verwenden",
    USEPERCROLLSTTWARN    = "Wenn dies aktiviert ist, verwenden Sie bitte nur Zahlen zwischen 0 und 100.",
    VALUE                 = "Wert",
    VERSION               = "Ausführung",
    VIEWALL               = "Alle ansehen",
    VIEWCORERAID          = "Sehen Sie sich Core Raiders an",
    VIEWRAID              = "Sehen Sie sich Raid",
    VIEWRAIDSTANDBY       = "Überfall und Standby anzeigen",
    VIEWS                 = "Ansichten",
    VIEWSTANDBY           = "Standby-Liste anzeigen",
    VIEWWHITELISTBTN      = "Whitelist anzeigen",
    VIEWWHITELISTTTDESC   = "Wählt alle Offiziere auf Ihrer DKP-Liste aus, die auf der Whitelist stehen.",
    VISIBLE               = "sichtbar",
    WARNING               = "WARNUNG",
    WEEKLYDECAY           = "Wöchentlicher Zerfall",
    WEEKLYDECAYTTDESC     = "Menge an DKP, um die Sie DKP-Einträge als wöchentlichen Zerfall reduzieren möchten. Dies sollte eine positive Zahl sein. Wenn \"Nur ausgewählte Spieler\" unten nicht ausgewählt ist, gilt dies für alle Einträge.",
    WEEKLYDECAYTTWARN     = "Warnung: Kann nicht rückgängig gemacht werden.",
    WEEKLYDKPDECAY        = "Wöchentlicher DKP-Zerfall",
    WHISPER               = "Flüstern",
    WHISPERCMDSHELP       = "Flüsterbefehle (an designierte Offiziere)",
    WHITELISTBROADCASTED  = "Whitelist gesendet",
    WHITELISTEMPTY        = "Ihre Whitelist ist leer.",
    WHITELISTHEADER       = "Whitelist-Einstellungen |CFF444444 (Nur Leader) (Alpha)|r\n\nEs wird dringend empfohlen, diese Whitelist-Einstellung nur zu verwenden, wenn Sie einschränken möchten, für welche Officers Berechtigungen erforderlich sind. Wenn Sie möchten, dass alle Beamten über Berechtigungen verfügen, ignorieren Sie diese Einstellungsfunktion vollständig. Mit Vorsicht verwenden. (Wenn das Anwenden dieser Einstellungen Probleme verursacht, öffnen Sie die Datei \\WTF\\Accounts\\ACCOUNT_NAME\\SavedVariables\\MonolithDKP.lua mit einem Texteditor und löschen Sie die Tabelle MonDKP_Whitelist im unteren Bereich.)",
    WITH                  = "mit",
    WON                   = "gewonnen",
    WONBY                 = "gewonnen von",
    YES                   = "Ja",
    YOUCURRENTLYHAVE      = "Derzeit hast du",
    YOURBID               = "Ihr Gebot",
    YOURBIDOF             = "Ihr Gebot von",
    YOURTABLESARECURR     = "Ihre Tabellen sind derzeit",
    ZEROSUMBALANCE        = "Nullsummensaldo",
    ZEROSUMBALANCETTDESC  = "Sammelt automatisch alle DKP, die Raiders ausgegeben haben, um sie nach dem Kauf der Beute zu verteilen.",
    ZEROSUMBANK           = "Nullsummenbank",
    ZEROSUMDESCRIPTION    = "Mit Zero Sum DKP können Artikel entweder einen statischen Wert haben oder geboten werden. Wenn ein Spieler einen Gegenstand für das Gebot oder die Kosten des Gegenstands gewinnt, wird dieser DKP von ihnen abgezogen und gleichmäßig auf den Schlachtzug verteilt. Es wird empfohlen, Dezimalstellen über die Option \"DKP-Rundung\" zu verwenden, da gerundete ganze Zahlen Inflation verursachen oder DKP verlieren können. Das würde 9 Punkte über den Kosten verteilen.\n\nEx: |cffa335ee|Hitem:18824::::::::120:577::::::|h[Magma Tempered Boots]|h|r fällt und hat statische Kosten von 30 DKP. Spieler A gewinnt das Gebot, indem er die meisten DKP hat (oder nach Ermessen des Schlachtzugsführers verteilt wird, wenn ein Gleichstand besteht) und seine DKP um 30 reduziert wird. Dann erhält jedes Schlachtzugsmitglied 0,75 DKP.",
    ZEROSUMHEAD           = "Nullsumme",
    ZEROSUMITEMCOST       = "Zero Sum Item Costs",
    ZEROSUMITEMCOSTTTDESC = "Wählen Sie die Art der Artikelkosten aus, die Sie verwenden möchten. Static gibt Artikeln einen definierten Preis. Während Mindestgebot ermöglicht es den Spielern, ein Gebot abzugeben, das die Kosten definiert, während Sie einen Mindestgebotsschwellenwert festlegen.",
    ZONE                  = "Zone",

    CHANGELOG1            = "https://www.youtube.com/watch?v=tT4eN2ux76E",
    CHANGELOG2            = "",
    CHANGELOG3            = "",
    CHANGELOG4            = "",
    CHANGELOG5            = "",
    CHANGELOG6            = "",
    CHANGELOG7            = "",
    CHANGELOG8            = "",
    CHANGELOG9            = "",
    CHANGELOG10           = "",
  }
end